<?php $__env->startSection('content'); ?>
    
    <?php if($data): ?>
        <div class="sixteen wide tablet fifteen wide computer column ">
            <div class="ui segment">
                
                <h4 class="ui dividing header teal centered">EDITAR DATOS DE PERSONAL</h4>
                <br>

                <form class="ui form" id="frmEditar" autocomplete="off">
                    <input type="hidden" id="id_usuario" name="id_usuario" value="<?php echo e($data->id_usuario); ?>">

                    <div class="two fields">
                        <div class="field">
                            <label>Nombres</label>
                            <div class="ui small input ">
                              <input type="text" name="nombres" maxlength="50" oninput="$.upperCase(this)" value="<?php echo e($data->nombres); ?>">
                            </div>
                        </div>
                        <div class="field">
                            <label>Apellidos</label>
                            <div class="ui small input ">
                              <input type="text" name="apellidos" maxlength="50" oninput="$.upperCase(this)" value="<?php echo e($data->apellidos); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="two fields">
                        <div class="field">
                            <label>Usuario</label>
                            <div class="ui small input">
                              <input type="text" name="username" maxlength="20" value="<?php echo e($data->username); ?>">
                            </div>
                        </div>
                        <div class="field">
                            <label>DNI</label>
                            <div class="ui small input ">
                              <input type="text" name="dni" maxlength="8" value="<?php echo e($data->dni); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="two fields">
                        <div class="field">
                            <label>Fecha de Nacimiento</label>
                            <div class="ui small input ">
                              <input type="text" name="fecha_nacimiento" class="fecha_pas" value="<?php echo e($data->fecha_nacimiento); ?>">
                            </div>
                        </div>
                        <div class="field">
                            <label>Domicilio</label>
                            <div class="ui small input " >
                              <input type="text" name="domicilio" maxlength="200" oninput="$.upperCase(this)" value="<?php echo e($data->domicilio); ?>">
                            </div>
                        </div>
                    </div>   

                    <div class="two fields">
                        <div class="field">
                            <label>Telefono</label>
                            <div class="ui small input ">
                              <input type="text" name="telefono" maxlength="15" value="<?php echo e($data->telefono); ?>">
                            </div>
                        </div>
                        <div class="field">
                            <label>Email</label>
                            <div class="ui small input ">
                              <input type="email" name="email" maxlength="50" value="<?php echo e($data->email); ?>">
                            </div>
                        </div>
                    </div> 
                  
                    <div class="two fields">
                        <div class="field">
                            <label>Rol</label>
                            <select class="ui small input dropdown" name="id_rol">
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rol): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($rol->id_rol == $data->id_rol): ?>
                                        <option value="<?php echo e($rol->id_rol); ?>" selected> <?php echo e($rol->nombre); ?> </option>
                                    <?php else: ?>
                                        <option value="<?php echo e($rol->id_rol); ?>"> <?php echo e($rol->nombre); ?> </option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>  
                        </div>
                        <div class="field">
                            <label>Lugar de Trabajo</label>
                            <select class="ui small input dropdown" name="id_local">
                                <?php $__currentLoopData = $locales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $local): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($local->id_local == $data->id_local): ?>
                                        <option value="<?php echo e($local->id_local); ?>" selected> <?php echo e($local->nombre); ?> (<?php echo e(ucwords(mb_strtolower($local->direccion ))); ?>)</option>
                                    <?php else: ?>
                                        <option value="<?php echo e($local->id_local); ?>"> <?php echo e($local->nombre); ?> (<?php echo e(ucwords(mb_strtolower($local->direccion ))); ?>)</option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>  
                        </div>
                    </div>  

                    <div class="form_footer" >
                        <a class="ui left floated default button" href="<?php echo e(URL::previous()); ?>"><i class="arrow left icon"></i>REGRESAR</a>
                        <div class="ui right floated primary button btn_guardar"><i class="save icon"></i>GUARDAR</div>
                    </div>    
                </form>

            </div>
        </div>

        <!--start update modal -->
        <div class="ui small basic modal" id="update_modal">
            <div class="ui icon header"><i class="paper plane icon"></i>Guardar cambios</div>
            <div class="content" style="text-align: center; font-size: 16px">
              <p>¿Está seguro que quiere guardar los cambios que hizo?</p>
            </div>
            <div class="actions">
                <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
                <div class="ui green ok inverted button" title="Haga clic para guardar cambios"> <i class="checkmark icon"></i>Guardar</div>
            </div>
        </div>
        <!--end update modal -->
    <?php else: ?>
        <div class="sixteen wide tablet fifteen wide computer column ">
            <div class="ui segment">
                <h3 class="ui header black centered">No se encuentra el registro que desea editar</h3>
            </div>
        </div>    
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/usuario/editar.js')); ?>"></script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layout.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>