$(function () {

	/******************************************************************************/
	/* validacion de modal 1
	/******************************************************************************/
    $('[data-tab="one"]').form({
    	keyboardShortcuts: false,
    	fields: {
		    id_local: {
		        rules: [{ type : 'empty', prompt : 'Seleccione una opción'}]
		    },
		    id_proveedor: {
		        rules: [{ type : 'empty', prompt : 'Seleccione una opción'}]
		    },
		    tipo_comprobante: {
		    	depends: 'numero_comprobante',
		        rules: [{ type : 'empty', prompt : 'Seleccione una opción'}]
		    },
		    numero_comprobante: {
		    	depends: 'tipo_comprobante',
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
    	},
    	inline : true,
	});

    $('.tab_two').on('click', function() {
		if ($('[data-tab="one"]').form('is valid')) {
			$.tab('change tab', 'two');
		} else {
			$('[data-tab="one"]').form('validate form');
		}
  	});


	$('[name="tipo_compra"]').change(function() {
		var option= $("option:selected", this).val();
		
	  	if (option == "CONTADO") {
			$('#fecha_pago').css('visibility', 'hidden');
			$('[data-tab="one"]').form('remove fields', ['fecha_pago']);
			$('[data-tab="one"]').form('remove prompt', ['fecha_pago']);
			$('[name="fecha_pago"]').val(''); 
		}
		if (option == "CREDITO") {
			$('#fecha_pago').css('visibility', 'visible');
			$('[data-tab="one"]').form('add rule', 'fecha_pago', {
		        rules: [{ type : 'empty', prompt : 'Ingrese una fecha de pago'}]
		    });
		}
	});

	$('[name="fecha_pago"]').on('change', function(){
		if ($('[name="fecha_pago"]').val() !== '' ) {
			$('[data-tab="one"]').form('remove prompt', ['fecha_pago']);
		}
	}); 



	/******************************************************************************/
	/* validacion de modal 2
	/******************************************************************************/

	$('[data-tab="two"]').form({
		keyboardShortcuts: false,
    	fields: {
		    /*id_prod: {
		        rules: [{ type : 'empty', prompt : 'Seleccione un producto'}]
		    },
		    cant: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese una cantidad valida'},
		        ]
		    },
		    stock_alert: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'integer', prompt : 'Ingrese un numero entero'},
		        ]
		    },
		    precio_compra_tot: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un precio valido'},
		        ]
		    },
		    precio_venta_unit: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un precio valido'},
		        ]
		    }*/
    	},
    	inline : true,
	});

	$('.tab_one').on('click', function() {
    	$.tab('change tab', 'one');
  	});

	/*********************************************************************************************************/
	/* registra datos de compra
	/*********************************************************************************************************/


  	 $('.btn_registrar').on('click', function() {
  		var count=$("#tbody tr:first > td").length;
    	if (count > 0 && ($('#total_compra') !== "")) {
    		if ($('#total_compra').val() !== "") {
			  	if ($('[data-tab="two"]').form('is valid')) {
					$('#register_modal').modal({
		  				closable: false,
				    	onApprove : function() {
				    		sendForm();
					    }
			  		}).modal('show');  
				} else {
					$('[data-tab="two"]').form('validate form');
				}
			} else {
				swal("Los precios", "de los productos no son validos", "warning");
			}
		} else {
			swal("Por favor", "agregue algun producto a la lista", "warning");
		}
  	});	

  	function sendForm() {
	    var data = $('#frmNuevo').serialize();
        $.requestApi('/compra/registrar', data, 'POST', function (resolve) {
	        if (resolve) {
	            $.showMessages(resolve, true, APP_URL+'/compra/detalles/'+resolve.id_compra);
	        }
	    });
        return false;
	};

	/******************************************************************************/
	/* start: muestra oculta tipo de cambio
	/******************************************************************************/
	$('#moneda').change(function() {
		var option= $("option:selected", this).val();
		
	  	if (option != "SOLES") {
			$('.tipo_cambio').css('visibility', 'visible');
			$('#valor_cambio').val("3.30"); 

			$('[data-tab="two"]').form('add rule', 'valor_cambio', {
		        rules: [{ type : 'empty', prompt : 'Ingrese valor de cambio'},
		        		{ type : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'}]
		    });

			calcularTotal();
		} else {
			$('.tipo_cambio').css('visibility', 'hidden');
			$('#valor_cambio').val("1.00"); 

			$('[data-tab="two"]').form('remove fields', ['valor_cambio']);
			$('[data-tab="two"]').form('remove prompt', ['valor_cambio']);

			calcularTotal();
		}
	});

    /******************************************************************************/
	/* validacion igv de situacion impuesto
	/******************************************************************************/


	$('[name="situacion_impuesto"]').on('change', function(){
		if ($('[name="situacion_impuesto"]').val() !== 'AFECTO' ) {
			$('[name="valor_impuesto"]').val("0.00");
			//$('[name="valor_impuesto"]').attr('readonly', true);
		}
		else {
			$('[name="valor_impuesto"]').val(_IGV);
			//$('[name="valor_impuesto"]').attr('readonly', false);
		}
	}); 



	/*********************************************************************************************************/
	/* modal mostrar todos los productos
	/*********************************************************************************************************/
	function buscarNombreProducto(producto) {

        $._requestApi('/producto_local/getByNombre', {'search' : producto }, 'GET', function (resolve) {
	        if (resolve) {

	        	var datos = [];
                for( var i=0; i< resolve.length; i++ ){
                    resolve[i]['i'] = i+1;
                    if(resolve[i]){
                        datos.push(renderProductos(resolve[i]));
                    }
                }
                $('#tbody_productos').html(datos.join(''));
	        	
	    	}

	    	$("#btn_buscar_prod").removeClass('loading');
	    });


  	};

	$('.btn_buscar_producto').on('click', function() {
  		$('#buscar_producto_modal').modal('show'); 
  		$('#buscar_producto').val('');
  		//resetearTablaProducto();
  	});	


	$('#buscar_producto').on('keypress', function(e){
	    if (e.keyCode == 13){
	    	$("#btn_buscar_prod").addClass('loading');
	    	var producto = $('#buscar_producto').val();
    		buscarNombreProducto(producto);
    	}	
	});

	$('#btn_buscar_prod').on('click', function() {
		$("#btn_buscar_prod").addClass('loading');
    	var producto = $('#buscar_producto').val();
    	buscarNombreProducto(producto);
  	});


    $('body').on('click', '.btn_seleccionar_producto', function(){ 
    	var id = $(this).data("id");
    	$("#loader_busqueda").removeClass('disabled');
		$("#loader_busqueda").addClass('active');
        $._requestApi('/producto/getById2', {id_producto : id }, 'GET', function (resolve) {
	        if (resolve) {
	        	if (resolve.id_producto) {
		        	agregarTabla(resolve);	
		        }
		        $("#loader_busqueda").removeClass('active');
				$("#loader_busqueda").addClass('disabled');
				$('#buscar_producto_modal').modal('hide'); 
	        }	
	    });
  	});

  	/*********************************************************************************************************/
	/* funcion agregar a tabla
	/*********************************************************************************************************/

 	function agregarTabla(data) {
 		//console.log(data);
  		if (verificaExite(data.id_producto)) {
  			cant = parseFloat($('#cant'+data.id_producto).val());
  			$('#cant'+data.id_producto).val(cant + 1);
  			calculaSubtotal(data.id_producto);
  			calcularTotal();

  		} else {
  			agregarFila(data);
  		}
  	}

  	function agregarFila(data) {

		var nuevoProducto=''+
            '<tr class="rows" id="'+data.id_producto+'">'+
                '<td><input type="hidden" name="id_producto[]" value="'+data.id_producto+'"/>'+data.nombre+' '+(data.descripcion !== null ? data.descripcion : '')+'</td>'+
                '<td><input type="text" name="cantidad[]" class="cant '+data.id_producto+'" id="cant'+data.id_producto+'" value="0" size="1"></td>'+
                '<td><input type="text" name="precio_compra_unitario[]" class="prec '+data.id_producto+'"  id="prec'+data.id_producto+'"  value="'+(data.precio_compra !== null ? data.precio_compra : '') +'"  size="2"/></td>'+
                '<td><input type="text" name="precio_compra_total[]" readonly class="subt '+data.id_producto+'"   id="subt'+data.id_producto+'"  size="2"/></td>'+
                '<td style="display:none"><input type="hidden" name="precio_venta_unitario[]" class="prec_v '+data.id_producto+'"  id="prec_v'+data.id_producto+'" value="'+data.precio+'" /></td>'+
                '<td ><div class="ui mini vertical animated red button" onclick="quitarTabla(this)" title="Quitar de la lista"><div class="hidden content">Quitar</div><div class="visible content"><i class="times icon"></i></div></div></td>'+
            '</tr>';
          
        $("#tbody").append(nuevoProducto);

        calcularTotal(); 
  	}

  	/*********************************************************************************************************/
	/* start: calcula precios al presionar tecla
	/*********************************************************************************************************/
	$('body').on('click', '.subt', function(){
	 	$(this).attr("readonly", false);
	});

  	$('body').on('keyup', '.cant', function(){

  		$(this).val($(this).val().trim());
    	var arr = $(this).attr('class').split(" ");
        calculaSubtotal(arr[1]);
        calcularTotal(); 
	    
    });

    $('body').on('keyup', '.prec', function(){

    	$(this).val($(this).val().trim());
		var arr = $(this).attr('class').split(" ");
        calculaSubtotal(arr[1]);
        calcularTotal(); 
    	
    });
	
	$('body').on('keyup', '.subt', function(){
    	$(this).val($(this).val().trim());
        calcularTotal(); 
    });

	/*********************************************************************************************************/
	/* modal agregar proveedor
	/*********************************************************************************************************/
	$('.btn_nuevo_proveedor').on('click', function() {
  		$('#nuevo_proveedor_modal').modal('show'); 
  	});	

	$.fn.form.settings.rules.docExiste = function(value) {
	  	return (verificaExiste('numero_documento', value) > 0 ? false : true);
	};

	function verificaExiste(field, param) {
     	var count;
     	$.ajax({
     		async: false,
            url: APP_URL+'/proveedor/existeCampo',
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            type: 'GET',
            dataType: 'json',
            data: { campo: field, valor: param},
            success: function (data) {
                count = data;
            }
        });
        return count;
	};

  	$('#frmNevoProveedor').form({
  		keyboardShortcuts: false,
    	fields: {
	      	nombre: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    numero_documento: {
		        rules: [
		        	{ type : 'docExiste', prompt : 'El numero de documento ya fue registrado'},
		        	{ type : 'empty', prompt : 'Complete este campo'},
		        	{ type : 'integer', prompt : 'Ingrese solo números'}
		        ]
		    },
		    id_tipo_documento: {
		        rules: [{ type : 'empty', prompt : 'Seleccione una opción'}]
		    },
		    telefono: {
		    	optional: true,
		        rules: [{ type : 'integer', prompt : 'Ingrese solo números'}]
		    },
		    email: {
		    	optional: true,
		        rules: [{ type : 'email', prompt : 'Ingrese un email válido'}]
		    },
    	},
    	inline : true,
    });

  	$('[name="id_tipo_documento"]').change(function() {
	  	
	  	var option= $("option:selected", this).text();

	  	if (option == "RUC") {
	  		$('input[name="numero_documento"]').attr('maxlength', 11);
	  		$('#frmNevoProveedor').form('add rule', 'numero_documento', {
		        rules: [
		        	{ type : 'docExiste', prompt : 'El numero de documento ya fue registrado'},
		        	{ type : 'integer', prompt : 'Ingrese solo números'},
		        	{ type : 'exactLength[11]', prompt : 'El RUC debe tener {ruleValue} digitos'}
		        ]
		    });
	  	}
	  	if (option == "DNI") {
	  		$('input[name="numero_documento"]').attr('maxlength', 8);
	  		$('#frmNevoProveedor').form('add rule', 'numero_documento', {
		        rules: [
		        	{ type : 'docExiste', prompt : 'El numero de documento ya fue registrado'},
		        	{ type : 'integer', prompt : 'Ingrese solo números'},
		        	{ type : 'exactLength[8]', prompt : 'El DNI debe tener {ruleValue} digitos'}
		        ]
		    });
	  	}
	});

    $('.btn_registrar_proveedor').on('click', function() {
		if ($('#frmNevoProveedor').form('is valid')) {
			$("#loader_proveedor").removeClass('disabled');
			$("#loader_proveedor").addClass('active');
			var data = $('#frmNevoProveedor').serialize();
	        $._requestApi('/proveedor/registrar', data, 'POST', function (resolve) {
		        if (resolve) {
		            if (resolve.message === "success") {
		               $("select[name='id_proveedor']").append($('<option>', {
		                	value: resolve.id_proveedor,
		                	text: resolve.nombre+' ('+resolve.numero_documento+')',
		                	selected: true
		                }));
		                $.Helper.clearFields("#frmNevoProveedor");
		                $('#nuevo_proveedor_modal').modal('hide'); 
		            }
		            $("#loader_proveedor").removeClass('active');
					$("#loader_proveedor").addClass('disabled');
		        }
		    });

		} else {
			$('#frmNevoProveedor').form('validate form');
		}
  	});

  	/******************************************************************************/
	/* validacion porcentaje en precio de compra y venta de modal productos
	/******************************************************************************/


	$('[name="tipo_precio"]').change(function() {
		var option= $("option:selected", this).val();
		
	  	if (option == "1") {
			$('#frmNuevoProducto').form('remove fields', ['precio_compra']);
			$('#frmNuevoProducto').form('remove prompt', ['precio_compra']);
			$('#frmNuevoProducto').form('add rule', 'precio_compra', {
				optional: true,
		        rules: [{type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'}]
		    });
		}
		if (option == "2") {
			$('#frmNuevoProducto').form('add rule', 'precio_compra', {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
		        ]
		    });
		}
	});

	$('[name="tipo_precio"]').on('change', function(){
		if ($('[name="precio_compra"]').val() !== '' ) {
			$('#frmNuevoProducto').form('remove prompt', ['precio_compra']);
		}
	}); 


		/******************************************************************************/
	/* validacion porcentaje en precio de compra y venta por mayor
	/******************************************************************************/

	$('[name="tipo_precio_2"]').change(function() {
		var option= $("option:selected", this).val();
		
	  	if (option == "1") {
			$('#frmNuevoProducto').form('remove fields', ['precio_compra']);
			$('#frmNuevoProducto').form('remove prompt', ['precio_compra']);
			$('#frmNuevoProducto').form('add rule', 'precio_compra', {
				optional: true,
		        rules: [{type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'}]
		    });
		}
		if (option == "2") {
			$('#frmNuevoProducto').form('add rule', 'precio_compra', {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
		        ]
		    });
		}
	});

	$('[name="tipo_precio_2"]').on('change', function(){
		if ($('[name="precio_compra"]').val() !== '' ) {
			$('#frmNuevoProducto').form('remove prompt', ['precio_compra']);
		}
	}); 


	/*********************************************************************************************************/
	/* modal agregar producto
	/*********************************************************************************************************/  	
	$('.btn_nuevo_producto').on('click', function() {
  		$('#nuevo_producto_modal').modal('show'); 
  	});	

  	$.fn.form.settings.rules.codigoExiste = function(value) {
	  	return (verificaExiste('codigo_barras', value) > 0 ? false : true);
	};

  	$('#frmNuevoProducto').form({
  		keyboardShortcuts: false,
    	fields: {
	      	nombre: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    situacion_impuesto: {
		        rules: [{ type : 'empty', prompt : 'Seleccione una opcion'}]
		    },
		    tipo_impuesto: {
		        rules: [{ type : 'empty', prompt : 'Seleccione una opcion'}]
		    },
		    valor_impuesto: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
		        ]
		    },
		    precio: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
		        ]
		    },

		    precio_mayorista: {
		    	optional: true,
		        rules: [
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
		        ]
		    },
		    precio_compra: {
		    	optional: true,
		        rules: [
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
		        ]
		    },
		    codigo_barras: {
		    	optional: true,
		        //rules: [{ type : 'codigoExiste', prompt : 'Este codigo ya fue registrado en otro producto'}]
		    },
    	},
    	inline : true,
    });

    function verificaExiste(field, param) {
     	var count;
     	$.ajax({
     		async: false,
            url: APP_URL+'/producto/existeCampo',
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            type: 'GET',
            dataType: 'json',
            data: { campo: field, valor: param},
            success: function (data) {
                count = data;
            }
        });
        return count;
	};


    $('.btn_registrar_producto').on('click', function() {
		if ($('#frmNuevoProducto').form('is valid')) {

			if ( $('[name="precio"]').val() != 0 ) {
				
				$("#loader_producto").removeClass('disabled');
				$("#loader_producto").addClass('active');
				var data = $('#frmNuevoProducto').serialize();
		        $._requestApi('/producto/registrar', data, 'POST', function (resolve) {
			        if (resolve) {
			            if (resolve.message === "success") {

			        		agregarTabla(resolve);	

			                $.Helper.clearFields("#frmNuevoProducto", ["valor_impuesto"]);
			                $('#nuevo_producto_modal').modal('hide'); 
			            }
			            $("#loader_producto").removeClass('active');
						$("#loader_producto").addClass('disabled');
			        }
			    });

		    } else {
				swal("El precio de venta", "NO puede ser cero", "warning");
			}	

		} else {
			$('#frmNuevoProducto').form('validate form');
		}
  	});

});

/*********************************************************************************************************/
/* funciones de calculo
/*********************************************************************************************************/

function calculaSubtotal(id) { 
	var subt = (parseFloat($('#prec'+id).val()).toFixed(2)*parseFloat($('#cant'+id).val()).toFixed(2));
	$('#subt'+id).val(validaNumero($('#prec'+id).val()) && validaNumero($('#cant'+id).val())  ? subt.toFixed(2) : '');
}


function validaNumero(valor) {
    var expresion=/^[0-9]+([\.]{1}[0-9]+)?$/;
    return !expresion.test(valor) ? false : true; 
}

function verificaExite(id) {
	exist = false;
	$('#tbody tr').each(function() {
    	if (this.id == id) {
    		exist = true;
    	}
  	});

	return exist;
}

function calcularTotal() {
	var total = 0;
	$('#tbody').find('tr').each(function(index, element) {
	    $(element).find('input').each(function(index1, element1) {
	        if(index1==3) { //Index empieza en 0 incluye hiddens
	            temp = parseFloat($(element1).val());
	            total+= temp;
	        }
	    });
	});
	$('#total_compra').val(!isNaN(total) ? total.toFixed(2) : '');
}

function quitarTabla(elem) {
    var elementoEliminar=$(elem).parent().parent();
    $(elementoEliminar).remove();
    calcularTotal();
}


function renderProductos(resolve){
	var arr = [];
    arr = [
        '<tr data-table="'+resolve.id_producto+'">',
            '<td>',resolve.i,'</td>',
            '<td>',resolve.producto.codigo_barras,'</td>',
            '<td>',resolve.producto.nombre,'</td>',
            '<td>',resolve.producto.descripcion,'</td>',
            '<td>',resolve.producto.tipo_presentacion.nombre,'</td>',
            '<td>',resolve.producto.precio,'</td>',
            '<td>', (resolve.producto.fecha_vencimiento !== '' ? resolve.producto.fecha_vencimiento : "Sin fecha") ,'</td>',
            '<td><div class="ui mini vertical animated positive button btn_seleccionar_producto" title="Seleccionar este producto" data-id="',resolve.id_producto,'"><div class="hidden content">Elegir</div><div class="visible content"><i class="check icon"></i></div></div></td>',
        '</tr>',
    ];
    return arr.join(''); 
}