<?php 

	include("config.php");
	require_once("phpexcel/PHPExcel.php");

	if (PHP_SAPI == 'cli')
    	die('Este archivo solo se puede ver desde un navegador web');
	
	// Se crea el objeto PHPExcel
	$objPHPExcel = new PHPExcel();

	$id_local = $_GET['id_local'];

	$conexion = new mysqli($db_host,$db_user,$db_pass,$db_name);
	if (mysqli_connect_errno()) {
	   printf("La conexión con el servidor de base de datos falló: %s\n", mysqli_connect_error());
	   exit();
	}

	if ($id_local == 0) {
		$consulta = 'SELECT pl.stock as stock, l.nombre as local, l.direccion as direccion, p.* , u.nombre as unidad, t.nombre as presentacion FROM producto_local pl INNER JOIN local l ON pl.id_local=l.id_local INNER JOIN productos p ON pl.id_producto=p.id_producto INNER JOIN tipo_presentacion t ON t.id_tipo_presentacion = p.id_tipo_presentacion INNER JOIN unidad_medida u ON u.id_unidad_medida = p.id_unidad_medida WHERE pl.estado=1 ORDER BY pl.stock ASC';
	} else{
		$consulta = 'SELECT pl.stock as stock, l.nombre as local, l.direccion as direccion, p.* , u.nombre as unidad, t.nombre as presentacion FROM producto_local pl INNER JOIN local l ON pl.id_local=l.id_local INNER JOIN productos p ON pl.id_producto=p.id_producto INNER JOIN tipo_presentacion t ON t.id_tipo_presentacion = p.id_tipo_presentacion INNER JOIN unidad_medida u ON u.id_unidad_medida = p.id_unidad_medida WHERE pl.id_local="'.$id_local.'"  AND pl.estado=1 ORDER BY pl.stock ASC';
	}		

	 
	$resultado = $conexion->query($consulta);

	if($resultado->num_rows > 0 ){

		// Propiedades del documento
		$objPHPExcel->getProperties()->setCreator("Seven")
									 ->setLastModifiedBy("Seven")
									 ->setTitle("Reporte de PRODUCTOS EN STOCK")
									 ->setSubject("Reporte de PRODUCTOS EN STOCK")
									 ->setDescription("Reporte de PRODUCTOS EN STOCK")
									 ->setKeywords("office 2010 openxml php")
									 ->setCategory("Archivo con resultado de reporte");
		
		// Combino las celdas desde A1 hasta F1
		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:H1');
		$objPHPExcel->setActiveSheetIndex(0)
		            ->setCellValue('A1', 'REPORTE DE PRODUCTOS EN STOCK')
		            ->setCellValue('A2', 'ITEM')
		            ->setCellValue('B2', 'NOMBRE')
		            ->setCellValue('C2', 'MARCA')
		            ->setCellValue('D2', 'CODIGO DE BARRAS')
					->setCellValue('E2', 'UND MEDIDA')
					->setCellValue('F2', 'PRESENTACION')
					->setCellValue('G2', 'PRECIO POR MAYOR S/')
					->setCellValue('H2', 'P. VENTA UNITARIO S/')
					->setCellValue('I2', 'P. COMPRA S/')
					->setCellValue('J2', 'UTILIDAD S/')
					->setCellValue('K2', 'VENCIMIENTO')
					->setCellValue('L2', 'TIPO')
					->setCellValue('M2', 'STOCK')
					->setCellValue('N2', 'STOCK VALORIZADO')
					->setCellValue('O2', 'UBICACION');
					
		// Fuente de la primera fila en negrita
		$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
		$objPHPExcel->getActiveSheet()->getStyle('A1:O2')->applyFromArray($boldArray);

		//Ancho de las columnas
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(80);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(25);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(25);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(80);
	
		$i = 3; //Numero de fila donde se va a comenzar a rellenar
		//$suma = 0;
		$j = 1;
		while ($fila = $resultado->fetch_array()) {
			$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('A'.$i, $j)
			    ->setCellValue('B'.$i, utf8_encode($fila['nombre']))
			    ->setCellValue('C'.$i, utf8_encode($fila['descripcion']))
			    ->setCellValue('D'.$i, utf8_encode($fila['codigo_barras']))
			    ->setCellValue('E'.$i, utf8_encode($fila['unidad']))
			    ->setCellValue('F'.$i, utf8_encode($fila['presentacion']))
			    ->setCellValue('G'.$i, $fila['precio_mayorista'])
			    ->setCellValue('H'.$i, $fila['precio'])
			    ->setCellValue('I'.$i, $fila['precio_compra'])
			    ->setCellValue('J'.$i, $fila['utilidad'])
			    ->setCellValue('K'.$i, $fila['fecha_vencimiento'])
			    ->setCellValue('L'.$i, utf8_encode($fila['tipo_producto']))
			    ->setCellValue('M'.$i, ($fila['stock'] > 1000000 ? $fila['stock'] - 1000000 : 'AGOTADO'))
			    ->setCellValue('N'.$i, ($fila['stock'] > 1000000 ? ($fila['stock'] - 1000000)*$fila['precio'] : '0.00'))
			    ->setCellValue('O'.$i, utf8_encode($fila['local'].' ('.$fila['direccion'].')'));
			$i++;
			$j++;
			//$suma = $suma+$fila['Monto S/'];
		}

		//$objPHPExcel->setActiveSheetIndex(0)->setCellValue('F'.$i, "TOTAL");
		//$objPHPExcel->setActiveSheetIndex(0)->setCellValue('G'.$i, $suma);
		//$objPHPExcel->getActiveSheet()->getStyle('F'.$i)->getFont()->setBold(true);

		$color_style_array = [
		  'font'  => [
		    'color' => ['rgb' => 'FF0000'],
		    'bold' => true,
		  ]
		];

		$objPHPExcel->getActiveSheet()->getStyle('M3:M'.$i)->applyFromArray($color_style_array);
		$objPHPExcel->getActiveSheet()->getStyle('G3:G'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('H3:H'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('I3:I'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('J3:J'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('N3:N'.$i)->getNumberFormat()->setFormatCode('0.00');

		$i = $i-1;
		$H = "O".$i;
		$rango = "A2:$H";
		$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
		'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
		);
		$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);

		// Cambiar el nombre de hoja de cálculo
		$objPHPExcel->getActiveSheet()->setTitle('Reporte de Productos en Stock');

		// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
		$objPHPExcel->setActiveSheetIndex(0);

		// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="Reporte_stock.xlsx"');
		header('Cache-Control: max-age=0');
		 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
		exit;

	}
	else{
	    print_r('No hay resultados para mostrar');
	}



	






