<?php 

	include("config.php");
	require_once("phpexcel/PHPExcel.php");

	if (PHP_SAPI == 'cli')
    	die('Este archivo solo se puede ver desde un navegador web');
	
	// Se crea el objeto PHPExcel
	$objPHPExcel = new PHPExcel();

	$id_local = $_GET['id_local'];
	$fecha1 = $_GET['fecha1'];
	$fecha2 = $_GET['fecha2'];

	$conexion = new mysqli($db_host,$db_user,$db_pass,$db_name);
	if (mysqli_connect_errno()) {
	   printf("La conexión con el servidor de base de datos falló: %s\n", mysqli_connect_error());
	   exit();
	}

	if ($id_local == 0) {
		$consulta = 'SELECT p.nombre, p.codigo_barras, p.descripcion, p.lote, p.situacion_impuesto, ve.fecha_venta, v.precio_venta, v.descuento, v.cantidad , v.precio_venta_total as total, ve.nombre_comprobante, c.nombre as c_nombre, c.numero_documento as c_documento , u.nombres as nom_personal, u.apellidos as ap_personal FROM detalle_venta v INNER JOIN ventas ve ON ve.id_venta = v.id_venta INNER JOIN productos p ON p.id_producto = v.id_producto INNER JOIN clientes c ON c.id_cliente = ve.id_cliente INNER JOIN usuarios u ON u.id_usuario = ve.id_usuario WHERE (v.created_at >= "'.$fecha1.' 00:00:00" AND v.created_at <= "'.$fecha2.' 23:59:59") AND ve.id_nota IS NULL AND ve.estado="1" ORDER BY v.id_venta';
	} else{
		$consulta = 'SELECT p.nombre, p.codigo_barras, p.descripcion, p.lote, p.situacion_impuesto, ve.fecha_venta, v.precio_venta, v.descuento, v.cantidad , v.precio_venta_total as total, ve.nombre_comprobante, c.nombre as c_nombre, c.numero_documento as c_documento , u.nombres as nom_personal, u.apellidos as ap_personal FROM detalle_venta v INNER JOIN ventas ve ON ve.id_venta = v.id_venta INNER JOIN productos p ON p.id_producto = v.id_producto INNER JOIN clientes c ON c.id_cliente = ve.id_cliente INNER JOIN usuarios u ON u.id_usuario = ve.id_usuario WHERE (v.created_at >= "'.$fecha1.' 00:00:00" AND v.created_at <= "'.$fecha2.' 23:59:59") AND ve.id_local="'.$id_local.'" AND ve.id_nota IS NULL AND ve.estado="1" ORDER BY v.id_venta';
	}

	 
	$resultado = $conexion->query($consulta);

	if($resultado->num_rows > 0 ){

		// Propiedades del documento
		$objPHPExcel->getProperties()->setCreator("Seven")
									 ->setLastModifiedBy("Seven")
									 ->setTitle("Reporte de PRODUCTOS VENDIDOS")
									 ->setSubject("Reporte de PRODUCTOS VENDIDOS")
									 ->setDescription("Reporte de PRODUCTOS VENDIDOS")
									 ->setKeywords("office 2010 openxml php")
									 ->setCategory("Archivo con resultado de reporte");
		
		// Combino las celdas desde A1 hasta F1
		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:H1');
		$objPHPExcel->setActiveSheetIndex(0)
		            ->setCellValue('A1', 'REPORTE DE PRODUCTOS VENDIDOS ENTRE : '.$fecha1.' & '.$fecha2)
		            ->setCellValue('A2', 'ITEM')
		            ->setCellValue('B2', 'PRODUCTO')
		            ->setCellValue('C2', 'CODIGO BARRAS')
		            ->setCellValue('D2', 'LOTE / SERIE')
		            ->setCellValue('E2', 'MARCA')
					->setCellValue('F2', 'SITUACION DE IMPUESTO')
					->setCellValue('G2', 'CANTIDAD')
					->setCellValue('H2', 'PRECIO UNITARIO S/')
					->setCellValue('I2', 'DESCUENTO S/')
					->setCellValue('J2', 'TOTAL S/')
					->setCellValue('K2', 'N° COMPROBANTE')
					->setCellValue('L2', 'NOMBRE DE CLIENTE')
					->setCellValue('M2', 'N° DOCUMENTO')
					->setCellValue('N2', 'PERSONAL QUE REGISTRO LA VENTA')
					->setCellValue('O2', 'FECHA DE VENTA');
					
		// Fuente de la primera fila en negrita
		$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
		$objPHPExcel->getActiveSheet()->getStyle('A1:O2')->applyFromArray($boldArray);


		//Ancho de las columnas
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(150);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(25);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(30);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(50);
        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(80);
        $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(25);
	
		$i = 3; //Numero de fila donde se va a comenzar a rellenar
		$suma = 0;
		$j = 1;
		while ($fila = $resultado->fetch_array()) {
			$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('A'.$i, $j)
			    ->setCellValue('B'.$i, utf8_encode($fila['nombre']))
			    ->setCellValue('C'.$i, $fila['codigo_barras'])
			    ->setCellValue('D'.$i, $fila['lote'])
			    ->setCellValue('E'.$i,  utf8_encode($fila['descripcion']))
			    ->setCellValue('F'.$i,  utf8_encode($fila['situacion_impuesto']))
			    ->setCellValue('G'.$i, $fila['cantidad'])
			    ->setCellValue('H'.$i, $fila['precio_venta'])
			    ->setCellValue('I'.$i, $fila['descuento'])
			    ->setCellValue('J'.$i, $fila['total'])
			    ->setCellValue('K'.$i, $fila['nombre_comprobante'])
			    ->setCellValue('L'.$i, utf8_encode($fila['c_nombre']))
			    ->setCellValue('M'.$i, $fila['c_documento'])
			    ->setCellValue('N'.$i, utf8_encode($fila['nom_personal'].' '.$fila['ap_personal']))
			    ->setCellValue('O'.$i, $fila['fecha_venta']);
			$i++;
			$j++;
			$suma = $suma+$fila['total'];
		}

		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('I'.$i, "TOTAL");
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('J'.$i, $suma);
		$objPHPExcel->getActiveSheet()->getStyle('I'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('J'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('H3:H'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('I3:I'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('J3:J'.$i)->getNumberFormat()->setFormatCode('0.00');

		$i = $i-1;
		$H = "O".$i;
		$rango = "A2:$H";
		$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
		'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
		);
		$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);

		// Cambiar el nombre de hoja de cálculo
		$objPHPExcel->getActiveSheet()->setTitle('Reporte de Productos Vendidos');

		// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
		$objPHPExcel->setActiveSheetIndex(0);

		// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="Reporte_Productos_Vendidos.xlsx"');
		header('Cache-Control: max-age=0');
		 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
		exit;

	}
	else{
	    print_r('No hay resultados para mostrar');
	}



	






