<?php 

	include("config.php");
	require_once("phpexcel/PHPExcel.php");

	if (PHP_SAPI == 'cli')
    	die('Este archivo solo se puede ver desde un navegador web');
	
	// Se crea el objeto PHPExcel
	$objPHPExcel = new PHPExcel();

	$id_local = $_GET['id_local'];
	$fecha1 = $_GET['fecha1'];
	$fecha2 = $_GET['fecha2'];

	$conexion = new mysqli($db_host,$db_user,$db_pass,$db_name);
	if (mysqli_connect_errno()) {
	   printf("La conexión con el servidor de base de datos falló: %s\n", mysqli_connect_error());
	   exit();
	}

	if ($id_local == 0) {
		$consulta = 'SELECT pro.nombre as proveedor, p.nombre, p.codigo_barras, p.descripcion, p.lote, d.*, c.fecha_compra, c.observacion, c.tipo_comprobante, c.numero_comprobante , u.nombres as nom_personal, u.apellidos as ap_personal FROM detalle_compra d INNER JOIN productos p ON p.id_producto = d.id_producto INNER JOIN compras c ON c.id_compra = d.id_compra INNER JOIN usuarios u ON u.id_usuario = c.id_usuario INNER JOIN proveedores pro ON c.id_proveedor = pro.id_proveedor WHERE (d.created_at >= "'.$fecha1.' 00:00:00" AND d.created_at <= "'.$fecha2.' 23:59:59") AND c.estado = 1 ORDER BY d.id_compra';
	} else{
		$consulta = 'SELECT pro.nombre as proveedor,  p.nombre, p.codigo_barras, p.descripcion,  p.lote,  d.*, c.fecha_compra, c.observacion, c.tipo_comprobante, c.numero_comprobante , u.nombres as nom_personal, u.apellidos as ap_personal FROM detalle_compra d INNER JOIN productos p ON p.id_producto = d.id_producto INNER JOIN compras c ON c.id_compra = d.id_compra INNER JOIN local l ON c.id_local = l.id_local INNER JOIN usuarios u ON u.id_usuario = c.id_usuario INNER JOIN proveedores pro ON c.id_proveedor = pro.id_proveedor WHERE (d.created_at >= "'.$fecha1.' 00:00:00" AND d.created_at <= "'.$fecha2.' 23:59:59") AND c.id_local="'.$id_local.'" AND c.estado = 1 ORDER BY d.id_compra';
	}

	 
	$resultado = $conexion->query($consulta);

	if($resultado->num_rows > 0 ){

		// Propiedades del documento
		$objPHPExcel->getProperties()->setCreator("Seven")
									 ->setLastModifiedBy("Seven")
									 ->setTitle("Reporte de PRODUCTOS COMPRADOS")
									 ->setSubject("Reporte de PRODUCTOS COMPRADOS")
									 ->setDescription("Reporte de PRODUCTOS COMPRADOS")
									 ->setKeywords("office 2010 openxml php")
									 ->setCategory("Archivo con resultado de reporte");
		
		// Combino las celdas desde A1 hasta F1
		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:L1');
		$objPHPExcel->setActiveSheetIndex(0)
		            ->setCellValue('A1', 'REPORTE DE PRODUCTOS COMPRADOS ENTRE : '.$fecha1.' & '.$fecha2)
		            ->setCellValue('A2', 'ITEM')
		            ->setCellValue('B2', 'PRODUCTO')
		            ->setCellValue('C2', 'CODIGO BARRAS')
		            ->setCellValue('D2', 'LOTE / SERIE')
					->setCellValue('E2', 'MARCA')
					->setCellValue('F2', 'CANTIDAD')
					->setCellValue('G2', 'PRECIO DE COMPRA S/')
					->setCellValue('H2', 'TOTAL S/')
					->setCellValue('I2', 'COMPROBANTE')
					->setCellValue('J2', 'NUMERO')
					->setCellValue('K2', 'PRECIO DE VENTA S/')
					->setCellValue('L2', 'GANANCIA POR UNIDAD S/')
					->setCellValue('M2', 'PERSONAL QUE REGISTRO LA COMPRA')
					->setCellValue('N2', 'OBSERVACION')
					->setCellValue('O2', 'NOMBRE DEL PROVEEDOR')
					->setCellValue('P2', 'FECHA DE COMPRA');
					
		// Fuente de la primera fila en negrita
		$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
		$objPHPExcel->getActiveSheet()->getStyle('A1:P2')->applyFromArray($boldArray);


		//Ancho de las columnas
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(80);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(30);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(80);
        $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(80);
        $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(80);
        $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(25);
	
		$i = 3; //Numero de fila donde se va a comenzar a rellenar
		$suma = 0;
		$j = 1;
		while ($fila = $resultado->fetch_array()) {
			$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('A'.$i, $j)
			    ->setCellValue('B'.$i, utf8_encode($fila['nombre']))
			    ->setCellValue('C'.$i, $fila['codigo_barras'])
			    ->setCellValue('D'.$i, $fila['lote'])
			    ->setCellValue('E'.$i, utf8_encode($fila['descripcion']))
			    ->setCellValue('F'.$i, $fila['cantidad'])
			    ->setCellValue('G'.$i, $fila['precio_compra_unitario'])
			    ->setCellValue('H'.$i, $fila['precio_compra_total'])
			    ->setCellValue('I'.$i, utf8_encode($fila['tipo_comprobante']))
			    ->setCellValue('J'.$i, $fila['numero_comprobante'])
			    ->setCellValue('K'.$i, $fila['precio_venta_unitario'])
			    ->setCellValue('L'.$i, $fila['utilidad'])
			    ->setCellValue('M'.$i, utf8_encode($fila['nom_personal'].' '.$fila['ap_personal']))
			    ->setCellValue('N'.$i, utf8_encode($fila['observacion']))
			    ->setCellValue('O'.$i, utf8_encode($fila['proveedor']))
			    ->setCellValue('P'.$i, utf8_encode($fila['fecha_compra']));
			$i++;
			$j++;
			$suma = $suma+$fila['precio_compra_total'];
		}

		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('G'.$i, "TOTAL");
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('H'.$i, $suma);
		$objPHPExcel->getActiveSheet()->getStyle('G'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('H'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('G3:G'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('H3:H'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('K3:K'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('L3:L'.$i)->getNumberFormat()->setFormatCode('0.00');

		$i = $i-1;
		$H = "P".$i;
		$rango = "A2:$H";
		$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
		'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
		);
		$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);

		// Cambiar el nombre de hoja de cálculo
		$objPHPExcel->getActiveSheet()->setTitle('Reporte de Productos Comprados');

		// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
		$objPHPExcel->setActiveSheetIndex(0);

		// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="Reporte_Productos_Comprados.xlsx"');
		header('Cache-Control: max-age=0');
		 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
		exit;

	}
	else{
	    print_r('No hay resultados para mostrar');
	}



	






