<?php

namespace App\Http\Controllers;

use Auth;
use Illuminate\Http\Request;
use App\Models\ProductoLocal;
use App\Models\Producto;
use App\Models\Local;
use App\Models\Delivery;

class ProductoLocalController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }

    public function listar()
    {
        $res = ProductoLocal::with(['producto', 'local'])->where('estado', 1)->orderBy('id_producto', 'desc')->paginate(10);
        $locales = Local::with(['tipo_local'])->where('estado', 1)->get();

        return view('producto.listar_local', [ 'data' => $res, 'locales' => $locales, 'id_sucursal' => 0]); 
    }

    public function listar_local($id)
    {
        $res = ProductoLocal::with(['producto', 'local'])->where('id_local', $id)->where('estado', 1)->orderBy('id_producto', 'desc')->paginate(10);

        $locales = Local::with(['tipo_local'])->where('estado', 1)->get();

        return view('producto.listar_local', [ 'data' => $res, 'locales' => $locales, 'id_sucursal' => $id]); 
    }

	public function alertas(Request $request)
    {
        if ($request->ajax())
        {    
            $res =  [
                'stock' => ProductoLocal::with('producto')->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->where('stock','>', 1000000)->orderBy('stock', 'asc')->limit(8)->get(),

                'vencido' =>  ProductoLocal::select(['productos.id_producto', 'productos.nombre', 'producto_local.stock'])->join('productos', 'productos.id_producto','=', 'producto_local.id_producto')->where('producto_local.id_local', Auth::guard("usuario")->user()->id_local)->where('productos.estado', 1)->where('producto_local.estado', 1)->where('productos.fecha_vencimiento', '<=', date('Y-m-d'))->limit(4)->get(),

                'delivery' =>  Delivery::where('estado_delivery', 'PENDIENTE')->where('estado', 1)->where('id_local', Auth::guard("usuario")->user()->id_local)->count(),
            ];

            return response()->json($res); 
        }
	}

    public function getAll(Request $request)
    {
        if ($request->ajax())
        {
            $res = ProductoLocal::with('producto')->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->where('stock', '>', 0)->get();

            return response()->json($res);  
        }
    }

    public function getById(Request $request)
    {
        if ($request->ajax())
        {
            $res = ProductoLocal::with('producto', 'producto.unidad_medida', 'producto.tipo_presentacion')->where('id_producto', $request->id_producto)->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->first();

            return response()->json($res);  
        }
    }

    public function getByIdMayor(Request $request)
    {
        if ($request->ajax())
        {
            $res = ProductoLocal::with('producto', 'producto.unidad_medida', 'producto.tipo_presentacion')->where('id_producto', $request->id_producto)->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->first();

            return response()->json($res);  
        }
    }

    public function getByIdLocal(Request $request)
    {
        if ($request->ajax())
        {
            $res = ProductoLocal::with('local', 'producto', 'producto.unidad_medida', 'producto.tipo_presentacion')->where('id_producto', $request->id_producto)->where('id_local', $request->id_local)->where('estado', 1)->first();

            return response()->json($res);  
        }
    }

    public function getAllLocal(Request $request)
    {
        if ($request->ajax())
        {
            $res = ProductoLocal::with('local', 'producto', 'producto.unidad_medida', 'producto.tipo_presentacion')->where('id_local', $request->id_local)->where('estado', 1)->limit(50)->get();

            return response()->json($res);  
        }
    }


    public function getByCodBarras(Request $request)
    {
        if ($request->ajax())
        {
            $res = null;
            if (!empty($request->codigo_barras))
            {
                $prod = Producto::where('codigo_barras', $request->codigo_barras)->where('estado', 1)->get();

                for ($i=0; $i < count($prod); $i++) { 
                    $res2 = ProductoLocal::with('producto', 'producto.unidad_medida', 'producto.tipo_presentacion')->where('id_producto', $prod[$i]->id_producto)->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->first();
                    if ($res2) {
                        $res = ProductoLocal::with('producto', 'producto.unidad_medida', 'producto.tipo_presentacion')->where('id_producto', $prod[$i]->id_producto)->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->first();
                    }
                }
            }
            return response()->json($res);  
        }
    }
    

    public function getByNombre(Request $request)
    {
        if ($request->ajax())
        {
            $res = null;
            if (!empty($request->search))
            {
                $prod =  Producto::with(['tipo_presentacion'])->where(function ($query) {
                        $query->where('estado', '=', 1);
                    })->where(function ($query)  use ($request) {
                        $query->where('nombre', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('descripcion', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('codigo_barras', 'LIKE',  '%'.$request->search.'%');
                    })->limit(50)->get();

                if ($prod)
                { 
                    foreach ($prod as $data) {
                        $dato = ProductoLocal::with('producto', 'producto.unidad_medida', 'producto.tipo_presentacion')->where('id_producto', $data->id_producto)->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->where('stock', '>', 0)->first();

                        if ( !is_null($dato) ) {
                            $res[] = $dato;
                        }
                    }
                    
                }


            }

            return response()->json($res); 
             
        }
    }

    public function getByNombreLocal(Request $request)
    {
        if ($request->ajax())
        {
            $res = null;
            if (!empty($request->search))
            {
                $prod =  Producto::with(['tipo_presentacion'])->where(function ($query) {
                        $query->where('estado', '=', 1);
                    })->where(function ($query)  use ($request) {
                        $query->where('nombre', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('descripcion', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('codigo_barras', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('fecha_vencimiento', 'LIKE', '%'.$request->search.'%');
                    })->limit(50)->get();

                if ($prod)
                { 
                    foreach ($prod as $data) {
                        $res[] = ProductoLocal::with('producto', 'producto.unidad_medida', 'producto.tipo_presentacion')->where('id_producto', $data->id_producto)->where('id_local', $request->id_local)->where('estado', 1)->where('stock', '>', 1000000)->first();
                    }
                    
                }

            }

            return response()->json($res); 
             
        }
    }

}
